﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Types" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Obroty konta - zaznaczone</title>
	<script runat="server">

		
		void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
		{
			ZapisKsiegowy z = (ZapisKsiegowy)args.Row;
			colWinienOperacji.EditValue = (z.Winien.Symbol == z.WinienOperacji.Symbol && z.Winien == z.WinienOperacji) ? Currency.Empty : z.WinienOperacji;
			colMaOperacji.EditValue = (z.Ma.Symbol == z.MaOperacji.Symbol && z.Ma == z.MaOperacji) ? Currency.Empty : z.MaOperacji;
		}


		void ObrotyKonta_OnLoad(Object sender, EventArgs args)
		{
			INavigatorContext nav = (INavigatorContext)dc.Context[typeof(INavigatorContext)];
			if (nav == null || nav.SelectedRows == null || nav.SelectedRows.Length == 0 || !(nav.SelectedRows is ZapisKsiegowy[]))
				throw new ApplicationException("Wydruk wymaga listy z zaznaczonymi zapisami księgowymi.");

			Grid1.DataSource = nav.SelectedRows;
		}

	</script>
</head>
<body>
	<form id="ObrotyKonta" method="post" onload="ObrotyKonta_OnLoad" runat="server">

	<ea:DataContext ID="dc" runat="server" TypeName="Soneta.Ksiega.KontoBase, Soneta.Ksiega" />
	<cc1:ReportHeader ID="ReportHeader1" ContextTypeName="Soneta.Ksiega.OkresObrachunkowy,Soneta.Ksiega" DataMember0="." Title="Obroty konta | Okres obrachunkowy: </strong>{0}<strong> | </strong>Wybrane (zaznaczone) zapisy<strong>" runat="server" />

	<table width="100%" style="font-size: x-small; font-family: Tahoma">
		<tr>
			<td align="left"><ea:DataLabel ID="labelSymbol" DataMember="Symbol" runat="server" Font-Names="Tahoma" EncodeHTML="true" /></td>
			<td align="center"><ea:DataLabel ID="labelNazwa" DataMember="Nazwa" runat="server" Font-Names="Tahoma" EncodeHTML="true" /></td>
			<td align="right"><ea:DataLabel ID="labelWaluta" DataMember="Waluta" runat="server" Font-Names="Tahoma" /></td>
		</tr>
	</table>
	
	<p />

	<ea:Grid ID="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" Sort="Dekret.Numer.Symbol,Dekret.Data,Dekret.ID,Lp" RowTypeName="Soneta.Ksiega.ZapisKsiegowy,Soneta.Ksiega" RowsInRow="2" >
		<Columns>
			<ea:GridColumn runat="server" Width="20" DataMember="Numer" ID="colNumer" />
			<ea:GridColumn runat="server" Width="20" Align="Center" DataMember="Data" ID="colData" />
			<ea:GridColumn runat="server" Width="20" DataMember="NumerEwidencji" Caption="Nr ewidencji" ID="colNrEwidencji" />
			<ea:GridColumn runat="server" Width="20" DataMember="NumerDokumentu" Caption="Nr dokumentu" ID="colNrDokumentu" EncodeHTML="true" />
			<ea:GridColumn runat="server" DataMember="Konto.Symbol" Total="Info" Caption="Konto" ID="colSymbol" EncodeHTML="true" />
			<ea:GridColumn runat="server" DataMember="Opis"  ID="colOpis" EncodeHTML="true" />
			<ea:GridColumn runat="server" Width="20" Align="Right" DataMember="Winien.Value" Total="Sum" Caption="Winien" HideZero="True" Format="{0:n}" ID="colWinien" />
			<ea:GridColumn runat="server" Width="20" Align="Right" Caption="Winien operacji" ID="colWinienOperacji" HideZero="True" />
			<ea:GridColumn runat="server" Width="20" Align="Right" DataMember="Ma.Value" Total="Sum" Caption="Ma" HideZero="True" Format="{0:n}" ID="colMa" />
			<ea:GridColumn runat="server" Width="20" Align="Right" Caption="Ma operacji" ID="colMaOperacji" HideZero="True" />
		</Columns>
	</ea:Grid>

	<cc1:ReportFooter ID="ReportFooter1" runat="server">
		<Subtitles>
			<cc1:FooterSubtitle runat="server" SubtitleType="Operator" />
		</Subtitles>
	</cc1:ReportFooter>
	</form>
</body>
</html>

